<?php $__env->startSection('title', 'History Detail'); ?>


<?php $__env->startSection('content'); ?>
    <div class="card mb-3">
        <div class="card-body">
            <form id="form-update-general" action="<?php echo e(route('workflow.update-general')); ?>" enctype="multipart/form-data" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e($row->id); ?>">
                <div class="row">
                    <div class="col-12 col-xl-6 col-lg-6">
                        <div class="mb-3">
                            <label class="form-label">Workflow Name</label>
                            <input type="text" name="title" class="form-control" autocomplete="off" required value="<?php echo e($row->title); ?>">
                        </div>
                    </div>
                    <div class="col-12 col-xl-6 col-lg-6">
                        <div class="mb-3">
                            <label class="form-label">Device (Sender)</label>
                            <select name="session_id" required class="form-select">
                                <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ss): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ss->id); ?>" <?php echo e($ss->id == $row->session_id ? 'selected' : ''); ?>><?php echo e($ss->session_name); ?> ( <?php echo e($ss->whatsapp_number); ?> )</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-12 col-xl-6 col-lg-6">
                        <div class="mb-3">
                            <label class="form-label">Message Template</label>
                            <select name="message_template_id" required class="form-select">
                                <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($template->id); ?>" <?php echo e($template->id == $row->message_template_id ? 'selected' : ''); ?>><?php echo e($template->title); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="text-end mt-3">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-xl-6 col-lg-6">
            <div class="card mb-3">
                <div class="card-body">
                    <div class="mb-3 fw-bold fs-5">Webhook Callback Url</div>
                    <div class="p-3 bg-light rounded" style="user-select: all;" ><?php echo config('app.base_node'); ?>/api/workflow/<?php echo e($row->slug); ?></div>
                </div>
            </div>
            <div class="card mb-3">
                <div class="card-body">
                    <div class="mb-3 fw-bold fs-5">Webhook Response Mapping</div>
                      <form id="form-update-mapping" action="<?php echo e(route('workflow.update-variable')); ?>" enctype="multipart/form-data" method="POST" style="display: none" >
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($row->id); ?>">
                        <div class="mb-3">
                            <label for=""><span class="fw-semibold">Variable:</span> Receiver</label>
                            <select name="variables[receiver]" class="form-control" data-select-raw>
                            </select>
                        </div>
                        <?php
                            preg_match_all('/\{(.*?)\}/', $row->template->message, $matches);
                            $variables = $matches[1];
                        ?>
                        <?php $__currentLoopData = $variables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3">
                                <label for=""><span class="fw-semibold">Variable:</span> <?php echo e($item); ?></label>
                                <select name="variables[<?php echo e($item); ?>]" class="form-control" data-select-raw>
                                </select>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="text-end mt-3">
                            <button type="submit" class="btn btn-primary">Save Changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-12 col-xl-6 col-lg-6">
            <div class="card mb-3">
                <div class="card-body">
                    <div class="mb-3 fw-bold fs-5">Raw</div>
                    <div class="mb-3" id="raw-render">

                    </div>
                    <div class="text-center">
                        <button type="button" class="btn btn-primary" data-click-capture <?php echo e($row->status == 'dev' ? 'disabled' : ''); ?>>
                        <?php if($row->status == 'dev'): ?>
                            <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span> Waiting for response...
                        <?php else: ?>
                            Capture Response
                        <?php endif; ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo asset('assets/libvelixs/client-dist/socket.io.js'); ?>"></script>
<script>
    let limit_attempts = <?php echo e(config('app.attemp_socket')); ?>;
    let attempts = 0;
    <?php if(config('app.socket_default')): ?>
        const socket = io();
    <?php else: ?>
        const socket = io("<?php echo e(config('app.base_node')); ?>", {
            transports: ['websocket']
        });
    <?php endif; ?>

    socket.on('workflow_callback', (data) => {
        if (data.workflow_id != "<?php echo e($row->id); ?>") return;

        const clone = { ...data };
        delete clone.workflow_id;

        $("#raw-render").html(`<pre>${JSON.stringify(clone, null, 2)}</pre>`);

        const wrapperSelectRaw = document.querySelectorAll('[data-select-raw]');
        wrapperSelectRaw.forEach((item) => {
            item.innerHTML = '';

            if (clone.body && Object.keys(clone.body).length > 0) {
                let options = '';
                Object.entries(clone.body).forEach(([key, value]) => {
                    options += `<option value="body.${key}">body.${key} : ${value}</option>`;
                });
                item.insertAdjacentHTML('beforeend', `<optgroup label="Body">${options}</optgroup>`);
            }

            if (clone.query && Object.keys(clone.query).length > 0) {
                let options = '';
                Object.entries(clone.query).forEach(([key, value]) => {
                    options += `<option value="query.${key}">query.${key} : ${value}</option>`;
                });
                item.insertAdjacentHTML('beforeend', `<optgroup label="Query">${options}</optgroup>`);
            }

            if (clone.headers && Object.keys(clone.headers).length > 0) {
                let options = '';
                Object.entries(clone.headers).forEach(([key, value]) => {
                    options += `<option value="headers.${key}">headers.${key} : ${value}</option>`;
                });
                item.insertAdjacentHTML('beforeend', `<optgroup label="Headers">${options}</optgroup>`);
            }
        });

        $("[data-click-capture]").removeAttr('disabled')
        $("[data-click-capture]").html('Capture Response')
        $("form#form-update-mapping").show();
    });

    var ilsya = new velixs()
    $("form#form-update-general").submit(function(e) {
        e.preventDefault()
        ilsya.ajax({
            url: $(this).attr('action'),
            data: $(this).serialize(),
            addons_success: function() {
                window.location.reload()
            }
        })
    })

    $("form#form-update-mapping").submit(function(e) {
        e.preventDefault()
        ilsya.ajax({
            url: $(this).attr('action'),
            data: $(this).serialize(),
            addons_success: function() {
            }
        })
    })

    $("[data-click-capture]").click(function() {
        $("[data-click-capture]").attr('disabled', 'disabled')
        $("[data-click-capture]").html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span> Waiting for response...')
        ilsya.ajax({
            url: "<?php echo e(route('workflow.capture-dev', ':id')); ?>".replace(':id', "<?php echo e($row->id); ?>"),
            data: $(this).serialize(),
            success: function(res) {
                Swal.close()
            }
        })
    })
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dash.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\NGODING\www\wa-lazy\core\resources\views/workflow/edit.blade.php ENDPATH**/ ?>